<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'token', 'status', 'item_discount', 'tax', 'tax_amount', 'shipping', 'total', 'coupon', 'coupon_id', 'payment_type', 'payment_at', 'cancelled_at', 'delivered_at', 'currency_exchange_rate', 'country_id', 'receipt_from_branch', 'address', 'latitude', 'longitude', 'city');

	public function user()
	{
		return $this->belongsTo('Models\User');
	}

	public function coupon()
	{
		return $this->belongsTo('Models\Coupon');
	}

	public function orderItems()
	{
		return $this->hasMany('Models\OrderItem');
	}

	public function country()
	{
		return $this->belongsTo('Models\Country');
	}

}