<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function sub_categories()
    {
        return $this->hasMany('Models\Category');
    }

    public function brands()
    {
        return $this->hasMany('Models\Brand');
    }

    public function products()
    {
        return $this->belongsToMany('Models\Product');
    }

}