<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Country extends Model 
{

    protected $table = 'countries';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'exemption_from_shipping_cost', 'minimum_order_to_show_gifts', 'image', 'currency_exchange_rate', 'status', 'currency', 'item_wrapping_price', 'delivery_time');

    public function country_admins()
    {
        return $this->hasMany('Models\CountryAdmin');
    }

    public function country_roles()
    {
        return $this->hasMany('Models\CountryRole');
    }

    public function users()
    {
        return $this->hasMany('Models\User');
    }

    public function discountOpportunities()
    {
        return $this->hasMany('Models\DiscountOpportunity');
    }

    public function banners()
    {
        return $this->hasMany('Models\Banner');
    }

    public function coupons()
    {
        return $this->hasMany('Models\Coupon');
    }

    public function welcomeMessage()
    {
        return $this->hasOne('Models\WelcomeMessage');
    }

    public function banks()
    {
        return $this->hasMany('Models\CountryBank');
    }

    public function paymentMethods()
    {
        return $this->belongsToMany('Models\PaymentMethod');
    }

    public function orders()
    {
        return $this->hasMany('Models\Order');
    }

}