<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductReviewsTable extends Migration {

	public function up()
	{
		Schema::create('product_reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('product_id')->unsigned();
			$table->float('rate');
			$table->text('comment');
			$table->bigInteger('user_id')->unsigned();
			$table->enum('status', array('waiting', 'approved'));
		});
	}

	public function down()
	{
		Schema::drop('product_reviews');
	}
}