<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminsTable extends Migration {

	public function up()
	{
		Schema::create('admins', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('email', 191)->unique();
			$table->string('phone', 191)->unique()->nullable();
			$table->string('password', 191);
			$table->boolean('block')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('admins');
	}
}