<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdjustmentsTable extends Migration {

	public function up()
	{
		Schema::create('adjustments', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('type');
			$table->string('modelable_type', 255);
			$table->bigInteger('modelable_id');
			$table->string('adjustment_type');
			$table->double('amount');
			$table->datetime('date')->nullable();
			$table->text('note');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('adjustments');
	}
}