<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('category_id')->unsigned();
			$table->string('product_name', 200)->nullable();
			$table->string('description')->nullable();
			$table->string('image')->nullable();
			$table->integer('quantity')->default('0');
			$table->double('price')->nullable();
			$table->double('discount')->nullable();
			$table->double('discount_in_precent')->nullable();
			$table->bigInteger('bonuses')->nullable();
			$table->integer('x_of_bonuses')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}