<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('category_id', 'product_name', 'description', 'image', 'quantity', 'price', 'discount', 'discount_in_precent', 'bonuses', 'x_of_bonuses');

	public function category()
	{
		return $this->belongsTo('App\Models\Category', 'category_id');
	}

}