<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHomeFeaturesTable extends Migration {

	public function up()
	{
		Schema::create('home_features', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('slug', 191)->unique();
			$table->text('link')->nullable();
			$table->text('image')->nullable();
			$table->integer('created_by')->nullable();
			$table->boolean('status')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('home_features');
	}
}