<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMenuItemsTable extends Migration {

	public function up()
	{
		Schema::create('menu_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('label', 191);
			$table->text('link')->nullable();
			$table->integer('parent')->nullable();
			$table->integer('sort');
			$table->string('class', 191)->nullable();
			$table->integer('menu')->nullable();
			$table->integer('depth')->nullable();
			$table->boolean('url_target')->default(0);
			$table->text('image')->nullable();
			$table->integer('menu_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('menu_items');
	}
}