<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('sports_page_id')->unsigned();
			$table->softDeletes();
			$table->string('name', 16)->nullable();
			$table->string('email', 32)->nullable();
			$table->string('phone', 16);
			$table->string('password', 16);
			$table->string('type', 8);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}