<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('visits', function(Blueprint $table) {
			$table->foreign('visitor_id')->references('id')->on('visitors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('participants', function(Blueprint $table) {
			$table->foreign('visit_id')->references('id')->on('visits')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('visits', function(Blueprint $table) {
			$table->dropForeign('visits_visitor_id_foreign');
		});
		Schema::table('participants', function(Blueprint $table) {
			$table->dropForeign('participants_visit_id_foreign');
		});
	}
}