<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('restaurant_translations', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('restaurant_activations', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('restaurant_payments', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('restaurant_payments', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('country_translations', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('restaurant_translations', function(Blueprint $table) {
			$table->dropForeign('restaurant_translations_restaurant_id_foreign');
		});
		Schema::table('restaurant_activations', function(Blueprint $table) {
			$table->dropForeign('restaurant_activations_restaurant_id_foreign');
		});
		Schema::table('restaurant_payments', function(Blueprint $table) {
			$table->dropForeign('restaurant_payments_restaurant_id_foreign');
		});
		Schema::table('restaurant_payments', function(Blueprint $table) {
			$table->dropForeign('restaurant_payments_payment_id_foreign');
		});
		Schema::table('country_translations', function(Blueprint $table) {
			$table->dropForeign('country_translations_country_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
	}
}