<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCreditsTable extends Migration {

	public function up()
	{
		Schema::create('credits', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('game_id')->unsigned()->nullable();
			$table->enum('status', array('charge', 'discharge'));
			$table->float('amount', 500)->nullable();
			$table->float('stock')->nullable();
			$table->string('description', 5000)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('credits');
	}
}