<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFilesTable extends Migration {

	public function up()
	{
		Schema::create('files', function(Blueprint $table) {
			$table->increments('id');
			$table->string('path', 1000)->nullable();
			$table->string('extentions', 1000)->nullable();
			$table->string('hash', 3000)->nullable();
			$table->string('original_name', 1000)->nullable();
			$table->integer('size')->nullable()->default('0');
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('entity_type')->unsigned()->nullable();
			$table->integer('entity_id')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('files');
	}
}