<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFirewallTable extends Migration {

	public function up()
	{
		Schema::create('firewall', function(Blueprint $table) {
			$table->increments('id');
			$table->string('ip_address', 50)->nullable();
			$table->tinyInteger('whitelisted')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('firewall');
	}
}