<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('credits', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('credits', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('games')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('games', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('games', function(Blueprint $table) {
			$table->foreign('attached')->references('id')->on('files')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->foreign('entity_type')->references('id')->on('entities')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('hit_logs', function(Blueprint $table) {
			$table->foreign('entity_type')->references('id')->on('entities')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('hit_logs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('action_id')->references('id')->on('games')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('log_accesses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('log_errors', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('sms_items', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('sms_items', function(Blueprint $table) {
			$table->foreign('receiver_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('actions', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('games')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('actions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('actions', function(Blueprint $table) {
			$table->foreign('answer_id')->references('id')->on('games_answers')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('games_answers', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('games')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_parent_id_foreign');
		});
		Schema::table('credits', function(Blueprint $table) {
			$table->dropForeign('credits_user_id_foreign');
		});
		Schema::table('credits', function(Blueprint $table) {
			$table->dropForeign('credits_game_id_foreign');
		});
		Schema::table('games', function(Blueprint $table) {
			$table->dropForeign('games_category_id_foreign');
		});
		Schema::table('games', function(Blueprint $table) {
			$table->dropForeign('games_attached_foreign');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->dropForeign('files_user_id_foreign');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->dropForeign('files_entity_type_foreign');
		});
		Schema::table('hit_logs', function(Blueprint $table) {
			$table->dropForeign('hit_logs_entity_type_foreign');
		});
		Schema::table('hit_logs', function(Blueprint $table) {
			$table->dropForeign('hit_logs_user_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_action_id_foreign');
		});
		Schema::table('log_accesses', function(Blueprint $table) {
			$table->dropForeign('log_accesses_user_id_foreign');
		});
		Schema::table('log_errors', function(Blueprint $table) {
			$table->dropForeign('log_errors_user_id_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_user_id_foreign');
		});
		Schema::table('sms_items', function(Blueprint $table) {
			$table->dropForeign('sms_items_user_id_foreign');
		});
		Schema::table('sms_items', function(Blueprint $table) {
			$table->dropForeign('sms_items_receiver_id_foreign');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->dropForeign('users_roles_user_id_foreign');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->dropForeign('users_roles_role_id_foreign');
		});
		Schema::table('actions', function(Blueprint $table) {
			$table->dropForeign('actions_game_id_foreign');
		});
		Schema::table('actions', function(Blueprint $table) {
			$table->dropForeign('actions_user_id_foreign');
		});
		Schema::table('actions', function(Blueprint $table) {
			$table->dropForeign('actions_answer_id_foreign');
		});
		Schema::table('games_answers', function(Blueprint $table) {
			$table->dropForeign('games_answers_game_id_foreign');
		});
	}
}