<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTwitterContentsTable extends Migration {

	public function up()
	{
		Schema::create('twitter_contents', function(Blueprint $table) {
			$table->increments('id');
			$table->string('content_type')->nullable();
			$table->integer('keyword_id')->unsigned()->nullable();
			$table->integer('account_id')->unsigned()->nullable();
			$table->string('author_str_id')->nullable();
			$table->text('content')->nullable();
			$table->text('link')->nullable();
			$table->datetime('publication_date')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('twitter_contents');
	}
}