<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('login_attempts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pois', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pois', function(Blueprint $table) {
			$table->foreign('gallery_id')->references('id')->on('galleries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mobile_surveys', function(Blueprint $table) {
			$table->foreign('mobile_user_id')->references('id')->on('mobile_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gallery_images', function(Blueprint $table) {
			$table->foreign('gallery_id')->references('id')->on('galleries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ar_tours', function(Blueprint $table) {
			$table->foreign('poi_id')->references('id')->on('pois')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ar_tours', function(Blueprint $table) {
			$table->foreign('gallery_id')->references('id')->on('galleries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('route_category', function(Blueprint $table) {
			$table->foreign('route_id')->references('id')->on('routes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('route_category', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('badge_poi', function(Blueprint $table) {
			$table->foreign('poi_id')->references('id')->on('pois')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('badge_poi', function(Blueprint $table) {
			$table->foreign('badge_id')->references('id')->on('badges')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('poi_user', function(Blueprint $table) {
			$table->foreign('mobile_user_id')->references('id')->on('mobile_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('poi_user', function(Blueprint $table) {
			$table->foreign('poi_id')->references('id')->on('pois')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('badge_user', function(Blueprint $table) {
			$table->foreign('badge_id')->references('id')->on('badges')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('badge_user', function(Blueprint $table) {
			$table->foreign('mobile_user_id')->references('id')->on('mobile_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_route', function(Blueprint $table) {
			$table->foreign('mobile_user_id')->references('id')->on('mobile_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('badge_route', function(Blueprint $table) {
			$table->foreign('badge_id')->references('id')->on('badges')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('badge_route', function(Blueprint $table) {
			$table->foreign('route_id')->references('id')->on('routes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('address_book_id')->references('id')->on('address_books')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('team_user', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('team_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('team_invitations', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_permission_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_role_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_role_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_user_id_foreign');
		});
		Schema::table('login_attempts', function(Blueprint $table) {
			$table->dropForeign('login_attempts_user_id_foreign');
		});
		Schema::table('pois', function(Blueprint $table) {
			$table->dropForeign('pois_category_id_foreign');
		});
		Schema::table('pois', function(Blueprint $table) {
			$table->dropForeign('pois_gallery_id_foreign');
		});
		Schema::table('mobile_surveys', function(Blueprint $table) {
			$table->dropForeign('mobile_surveys_mobile_user_id_foreign');
		});
		Schema::table('gallery_images', function(Blueprint $table) {
			$table->dropForeign('gallery_images_gallery_id_foreign');
		});
		Schema::table('ar_tours', function(Blueprint $table) {
			$table->dropForeign('ar_tours_poi_id_foreign');
		});
		Schema::table('ar_tours', function(Blueprint $table) {
			$table->dropForeign('ar_tours_gallery_id_foreign');
		});
		Schema::table('route_category', function(Blueprint $table) {
			$table->dropForeign('route_category_route_id_foreign');
		});
		Schema::table('route_category', function(Blueprint $table) {
			$table->dropForeign('route_category_category_id_foreign');
		});
		Schema::table('badge_poi', function(Blueprint $table) {
			$table->dropForeign('badge_poi_poi_id_foreign');
		});
		Schema::table('badge_poi', function(Blueprint $table) {
			$table->dropForeign('badge_poi_badge_id_foreign');
		});
		Schema::table('poi_user', function(Blueprint $table) {
			$table->dropForeign('poi_user_mobile_user_id_foreign');
		});
		Schema::table('poi_user', function(Blueprint $table) {
			$table->dropForeign('poi_user_poi_id_foreign');
		});
		Schema::table('badge_user', function(Blueprint $table) {
			$table->dropForeign('badge_user_badge_id_foreign');
		});
		Schema::table('badge_user', function(Blueprint $table) {
			$table->dropForeign('badge_user_mobile_user_id_foreign');
		});
		Schema::table('user_route', function(Blueprint $table) {
			$table->dropForeign('user_route_mobile_user_id_foreign');
		});
		Schema::table('badge_route', function(Blueprint $table) {
			$table->dropForeign('badge_route_badge_id_foreign');
		});
		Schema::table('badge_route', function(Blueprint $table) {
			$table->dropForeign('badge_route_route_id_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_address_book_id_foreign');
		});
		Schema::table('team_user', function(Blueprint $table) {
			$table->dropForeign('team_user_team_id_foreign');
		});
		Schema::table('team_user', function(Blueprint $table) {
			$table->dropForeign('team_user_user_id_foreign');
		});
		Schema::table('team_invitations', function(Blueprint $table) {
			$table->dropForeign('team_invitations_team_id_foreign');
		});
	}
}