<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('sub_category_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->string('name');
			$table->string('description');
			$table->string('image');
			$table->float('price');
			$table->integer('stock');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}