<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Model extends Eloquent {

	protected $table = 'models';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function root()
	{
		return $this->belongsTo('Root', 'root_id');
	}

	public function type()
	{
		return $this->belongsTo('Type', 'type_id');
	}

	public function purpose()
	{
		return $this->belongsTo('Purpose', 'purpose_id');
	}

	public function view()
	{
		return $this->belongsTo('View', 'view_id');
	}

}