<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PropertySpecificationProject extends Eloquent {

	protected $table = 'property_specification_projects';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function property_specification()
	{
		return $this->belongsTo('PropertySpecification', 'property_specification_id');
	}

	public function project()
	{
		return $this->belongsTo('Project', 'project_id');
	}

}