<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkHoursTable extends Migration {

	public function up()
	{
		Schema::create('Work_hours', function(Blueprint $table) {
			$table->increments('work_hour_id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('employee_party_id')->unsigned();
			$table->integer('project_id')->unsigned();
			$table->date('start_date')->nullable();
			$table->date('end_date');
			$table->boolean('approval_status');
			$table->integer('client_manager_party_id')->unsigned();
			$table->boolean('finance_processed_status');
			$table->integer('total_worked_hours');
		});
	}

	public function down()
	{
		Schema::drop('Work_hours');
	}
}