<?php

namespace EventLocation;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EventLocation extends Eloquent {

	protected $table = 'EventLocation';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function times()
	{
		return $this->belongsToMany('Time');
	}

	public function event()
	{
		return $this->belongsTo('Event');
	}

	public function location()
	{
		return $this->belongsTo('Location', 'location_id');
	}

}