<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestTable extends Migration {

	public function up()
	{
		Schema::create('request', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('provider_id')->unsigned();
			$table->integer('customer_id')->unsigned();
			$table->integer('service_id');
			$table->text('review_text');
			$table->string('review_star');
			$table->timestamps();
			$table->tinyInteger('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('request');
	}
}