<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Experiment extends Model 
{

    protected $table = 'experiments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('state');
    protected $fillable = array('name', 'description');

    public function experiment_metrics()
    {
        return $this->hasMany('ExperimentMetric');
    }

    public function experiment_conflicts()
    {
        return $this->hasMany('ExperimentConflict');
    }

    public function audience()
    {
        return $this->hasOne('Audience');
    }

}