<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExperimentsTable extends Migration {

	public function up()
	{
		Schema::create('experiments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->string('description', 255)->nullable();
			$table->enum('state', array('draft', 'scheduled', 'active', 'paused', 'aborted', 'completed'));
			$table->datetimeTz('start_datetime')->nullable();
			$table->datetimeTz('end_datetime')->nullable();
			$table->json('strata')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('experiments');
	}
}