<?php

namespace Model;

use Illuminate\Database\Eloquent\Model;

class Candidate extends Model 
{

    protected $table = 'candidates';
    public $timestamps = true;
    protected $fillable = array('name', 'status', 'country', 'state', 'city', 'email', 'phone', 'party');

    public function polling_area()
    {
        return $this->hasMany('Model\CandidatePolliingArea', 'candidate_id');
    }

    public function country()
    {
        return $this->belongsTo('Model\Country', 'country');
    }

    public function state()
    {
        return $this->belongsTo('Model\States', 'state');
    }

    public function party()
    {
        return $this->belongsTo('Model\Party', 'party');
    }

}