<?php

namespace Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ElectionPollingArea extends Model 
{

    protected $table = 'election_polling_areas';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('election_id', 'polling_area_id');

    public function election()
    {
        return $this->belongsTo('Model\Election', 'election_id');
    }

    public function polling_area()
    {
        return $this->hasMany('Model\PollingArea', 'polling_area_id');
    }

    public function candidate()
    {
        return $this->hasMany('Model\CandidatePolliingArea', 'election_polling_area_id');
    }

}