<?php

namespace Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PollingArea extends Model 
{

    protected $table = 'polling_areas';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'location', 'country', 'state', 'city');

    public function voter_detail()
    {
        return $this->hasMany('Model\VoterDetail', 'voter_area_id');
    }

    public function election()
    {
        return $this->hasMany('Model\ElectionPollingArea', 'polling_area_id');
    }

    public function voter_file()
    {
        return $this->hasMany('Model\VoterFile', 'polling_area_id');
    }

    public function sms()
    {
        return $this->hasMany('Model\VoterSms', 'polling_area_id');
    }

}