<?php

namespace Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class VoterFile extends Model 
{

    protected $table = 'voter_files';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('polling_area_id', 'name');

    public function file()
    {
        return $this->belongsTo('Model\PollingArea', 'polling_area_id');
    }

}