<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentMethodsTable extends Migration {

	public function up()
	{
		Schema::create('payment_methods', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id')->unsigned();
			$table->integer('address_id');
			$table->boolean('is_primary');
			$table->string('name_on_card');
			$table->tinyInteger('card_type_id');
			$table->smallInteger('expiration_month');
			$table->smallInteger('expiration_year');
			$table->smallInteger('last_four_digits');
			$table->enum('type', array(''))->nullable();
			$table->string('token', 255)->nullable();
			$table->string('token_type', 128);
			$table->integer('expires_in');
			$table->boolean('recurring');
			$table->timestamp('recurring_date');
			$table->string('frequency');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('payment_methods');
	}
}