<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGaragesTable extends Migration {

	public function up()
	{
		Schema::create('garages', function(Blueprint $table) {
			$table->bigInteger('id');
			$table->string('name_ar')->nullable();
			$table->string('name_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->text('description_en')->nullable();
			$table->string('record_number')->nullable();
			$table->string('logo')->nullable();
			$table->boolean('active')->default(true);
			$table->boolean('availablity')->default(true);
			$table->bigInteger('country_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('garages');
	}
}