<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSpecialNumberReservationsTable extends Migration {

	public function up()
	{
		Schema::create('special_number_reservations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('special_number_id')->unsigned();
			$table->string('name_ar')->nullable();
			$table->string('name_en')->nullable();
			$table->text('address_ar')->nullable();
			$table->text('address_en')->nullable();
			$table->string('phone')->nullable();
			$table->boolean('status')->default(true);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('special_number_reservations');
	}
}