<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('check_pcs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('check_pcs', function(Blueprint $table) {
			$table->foreign('collage_id')->references('id')->on('collages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('check_counter', function(Blueprint $table) {
			$table->foreign('collage_id')->references('id')->on('collages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('collages', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pcs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pcs', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('check_pcs', function(Blueprint $table) {
			$table->dropForeign('check_pcs_user_id_foreign');
		});
		Schema::table('check_pcs', function(Blueprint $table) {
			$table->dropForeign('check_pcs_collage_id_foreign');
		});
		Schema::table('check_counter', function(Blueprint $table) {
			$table->dropForeign('check_counter_collage_id_foreign');
		});
		Schema::table('collages', function(Blueprint $table) {
			$table->dropForeign('collages_department_id_foreign');
		});
		Schema::table('pcs', function(Blueprint $table) {
			$table->dropForeign('pcs_user_id_foreign');
		});
		Schema::table('pcs', function(Blueprint $table) {
			$table->dropForeign('pcs_department_id_foreign');
		});
	}
}