<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Application extends Eloquent {

	protected $table = 'applications';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function applicant()
	{
		return $this->belongsTo('Applicant');
	}

	public function program()
	{
		return $this->belongsTo('Program');
	}

	public function files()
	{
		return $this->hasMany('ApplicationFiles');
	}

	public function criteriaRatings()
	{
		return $this->hasMany('CriteriaRatings');
	}

}