<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class School extends Model 
{

    protected $table = 'schools';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function schoolType()
    {
        return $this->hasOne('SchoolType', 'school_type_id');
    }

    public function users()
    {
        return $this->hasMany('User', 'school_id');
    }

    public function academicYears()
    {
        return $this->hasMany('AcademicYear', 'school_id');
    }

    public function students()
    {
        return $this->hasMany('Student', 'school_id');
    }

}