<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentRequestTable extends Migration {

	public function up()
	{
		Schema::create('payment_request', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->morphs('user');
			$table->integer('transaction_id')->unsigned();
			$table->enum('status', array('pending', 'accept', 'rejected'));
		});
	}

	public function down()
	{
		Schema::drop('payment_request');
	}
}