<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('crawler_bots', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('sellers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('crawler_categories', function(Blueprint $table) {
			$table->foreign('bot_id')->references('id')->on('crawler_bots')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('crawler_products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('crawler_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('crawler_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('crawler_products', function(Blueprint $table) {
			$table->foreign('creator_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('crawler_logs', function(Blueprint $table) {
			$table->foreign('bot_id')->references('id')->on('crawler_bots')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('crawler_reject_product', function(Blueprint $table) {
			$table->foreign('crawler_product_id')->references('id')->on('crawler_products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('crawler_bots', function(Blueprint $table) {
			$table->dropForeign('crawler_bots_seller_id_foreign');
		});
		Schema::table('crawler_categories', function(Blueprint $table) {
			$table->dropForeign('crawler_categories_bot_id_foreign');
		});
		Schema::table('crawler_products', function(Blueprint $table) {
			$table->dropForeign('crawler_products_category_id_foreign');
		});
		Schema::table('crawler_products', function(Blueprint $table) {
			$table->dropForeign('crawler_products_product_id_foreign');
		});
		Schema::table('crawler_products', function(Blueprint $table) {
			$table->dropForeign('crawler_products_creator_id_foreign');
		});
		Schema::table('crawler_logs', function(Blueprint $table) {
			$table->dropForeign('crawler_logs_bot_id_foreign');
		});
		Schema::table('crawler_reject_product', function(Blueprint $table) {
			$table->dropForeign('crawler_reject_product_crawler_product_id_foreign');
		});
	}
}