<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCrawlerProductsTable extends Migration {

	public function up()
	{
		Schema::create('crawler_products', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('category_id')->unsigned();
			$table->integer('product_id')->unsigned();
			$table->string('link');
			$table->string('title');
			$table->string('image');
			$table->string('status');
			$table->tinyInteger('attempts');
			$table->timestamps();
			$table->timestamp('approved_at');
			$table->timestamps();
			$table->string('updaed_at');
			$table->integer('creator_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('crawler_products');
	}
}