<?php

namespace App/Models;

class Teacher extends Eloquent {

	protected $table = 'teachers';
	public $timestamps = true;

	public function categories()
	{
		return $this->hasOne('App/Models\Category');
	}

	public function cities()
	{
		return $this->hasOne('App/Models\City');
	}

	public function specializations()
	{
		return $this->belongsToMany('App/Models\Specialization');
	}

	public function levels()
	{
		return $this->belongsToMany('App/Models\Level');
	}

}