<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEPrescriptionsTable extends Migration {

	public function up()
	{
		Schema::create('e_prescriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('booking_id')->unsigned();
			$table->integer('npi');
			$table->string('dea', 10);
			$table->string('pharmacy_name', 299)->nullable();
			$table->string('pharmacy_address', 299)->nullable();
			$table->string('pharmacy_phone', 299)->nullable();
			$table->string('pharmacy_fax', 299)->nullable();
			$table->text('notes')->nullable();
			$table->timestamps();
			$table->tinyInteger('verification_status')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('e_prescriptions');
	}
}