<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMedicalHistoriesTable extends Migration {

	public function up()
	{
		Schema::create('medical_histories', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('user_id')->unsigned();
			$table->tinyInteger('whose_status')->default('0');
			$table->timestamps();
			$table->double('height_in_feet');
			$table->double('height_in_inch');
			$table->integer('relative_id')->unsigned()->nullable();
			$table->double('weight');
			$table->tinyInteger('smoke')->default('0');
			$table->tinyInteger('alcohol_status')->default('0');
			$table->tinyInteger('traveled_over_sea')->default('0');
			$table->date('doc_last_visit');
		});
	}

	public function down()
	{
		Schema::drop('medical_histories');
	}
}