<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorInfosTable extends Migration {

	public function up()
	{
		Schema::create('doctor_infos', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('doctor_id')->unsigned();
			$table->text('document_name')->nullable();
			$table->string('clinic_name', 299)->nullable();
			$table->string('speciality', 299)->nullable();
			$table->text('description')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('doctor_infos');
	}
}