<?php

namespace App\Models;

class BookingInfo extends Eloquent {

	protected $table = 'booking_infos';
	public $timestamps = true;
	protected $fillable = array('medical_problem', 'image_url');

	public function doctorsSlot()
	{
		return $this->hasOne('App\Models\DoctorSlot', 'slot_id');
	}

	public function doctor()
	{
		return $this->hasOne('App\Models\User', 'doctor_id');
	}

	public function history()
	{
		return $this->hasOne('App\Models\MedicalHistory', 'history_id');
	}

	public function e_prescription()
	{
		return $this->hasOne('App\Models\Eprescription', 'booking_id');
	}

}