<?php

namespace App\Models;

class PatientHealthProblem extends Eloquent {

	protected $table = 'patient_health_problems';
	public $timestamps = true;
	protected $fillable = array('history_id', 'health_problem_id');

	public function medical_history()
	{
		return $this->belongsTo('App\Models\User', 'id');
	}

	public function health_problem()
	{
		return $this->hasOne('App\Models\HealthProblem', 'health_problem_id');
	}

}