<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContratsTable extends Migration {

	public function up()
	{
		Schema::create('contrats', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('code_contrat', 255);
			$table->integer('id_saver')->unsigned();
			$table->integer('id_locataire')->unsigned();
			$table->integer('id_building')->unsigned();
			$table->datetime('date_debut')->nullable();
			$table->float('montant_loyer');
			$table->integer('nbre_mois')->default('0');
			$table->float('reduction')->default('0.0');
			$table->enum('etat', array('encours', 'resilie', 'annule'));
		});
	}

	public function down()
	{
		Schema::drop('contrats');
	}
}