<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('id_type')->references('id')->on('types_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contrats', function(Blueprint $table) {
			$table->foreign('id_saver')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contrats', function(Blueprint $table) {
			$table->foreign('id_locataire')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contrats', function(Blueprint $table) {
			$table->foreign('id_building')->references('id')->on('building')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('problemes', function(Blueprint $table) {
			$table->foreign('id_saver')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('problemes', function(Blueprint $table) {
			$table->foreign('id_validator')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('problemes', function(Blueprint $table) {
			$table->foreign('id_prestataire')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('problemes', function(Blueprint $table) {
			$table->foreign('id_contrat')->references('id')->on('contrats')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('depenses', function(Blueprint $table) {
			$table->foreign('id_probleme')->references('id')->on('problemes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('versements_salaire', function(Blueprint $table) {
			$table->foreign('id_employe')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('versements_salaire', function(Blueprint $table) {
			$table->foreign('id_saver')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_id_type_foreign');
		});
		Schema::table('contrats', function(Blueprint $table) {
			$table->dropForeign('contrats_id_saver_foreign');
		});
		Schema::table('contrats', function(Blueprint $table) {
			$table->dropForeign('contrats_id_locataire_foreign');
		});
		Schema::table('contrats', function(Blueprint $table) {
			$table->dropForeign('contrats_id_building_foreign');
		});
		Schema::table('problemes', function(Blueprint $table) {
			$table->dropForeign('problemes_id_saver_foreign');
		});
		Schema::table('problemes', function(Blueprint $table) {
			$table->dropForeign('problemes_id_validator_foreign');
		});
		Schema::table('problemes', function(Blueprint $table) {
			$table->dropForeign('problemes_id_prestataire_foreign');
		});
		Schema::table('problemes', function(Blueprint $table) {
			$table->dropForeign('problemes_id_contrat_foreign');
		});
		Schema::table('depenses', function(Blueprint $table) {
			$table->dropForeign('depenses_id_probleme_foreign');
		});
		Schema::table('versements_salaire', function(Blueprint $table) {
			$table->dropForeign('versements_salaire_id_employe_foreign');
		});
		Schema::table('versements_salaire', function(Blueprint $table) {
			$table->dropForeign('versements_salaire_id_saver_foreign');
		});
	}
}