<?php

namespace App;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('id_type', 'noms', 'email', 'password', 'salaire', 'telephone', 'cni', 'metier');
	protected $visible = array('id_type', 'noms', 'email', 'password', 'salaire', 'telephone', 'cni', 'metier');

	public function boutiques()
	{
		return $this->hasMany('App\Contrat', 'id_locataire');
	}

	public function type()
	{
		return $this->belongsTo('App\Types_user', 'id_type');
	}

	public function versements_salaires()
	{
		return $this->hasMany('App\Versement_salaire', 'id_employe');
	}

}