<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Login extends Model 
{

    protected $table = 'login';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->hasOne('App\User', 'user_id');
    }

    public function country()
    {
        return $this->hasOne('App\Country', 'ipcountry_id');
    }

}